﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="System.Collections.Generic" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.Forms" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kasa" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Zestawienie do PIT-28</title>
	<script runat="server">
		
		public class Params : ContextBase
		{
			private FromTo okres;
			private IPodmiot podmiot;

			private IPodmiot[] listPodmiot;
			private IPodmiot initialPodmiot;

						
			public Params(Context ctx)
				: base(ctx)
			{
				StdParams stdParams = (StdParams)ctx[typeof(StdParams)];
				okres = stdParams.Okres;

				if (ctx.Contains(typeof(PITRyczałt)))
				{
					PITRyczałt pit = (PITRyczałt)ctx[typeof(PITRyczałt)];
					initialPodmiot = pit != null ? pit.Podmiot : null;
				}

				OnOkresChanged();
			}


			public FromTo Okres
			{
				get { return okres; }
				set
				{
					if (okres != value)
					{
						okres = value;

						OnOkresChanged();
						OnChanged(EventArgs.Empty);
					}
				}
			}

			[Required]
			public IPodmiot Podmiot
			{
				get { return podmiot; }
				set { podmiot = value; }
			}


			public IPodmiot[] GetListPodmiot()
			{ return listPodmiot; }


			private void OnOkresChanged()
			{
				List<IPodmiot> wlasciciele = new List<IPodmiot>();
				
				DeklaracjeModule dm = DeklaracjeModule.GetInstance(Context);
				foreach (PITRyczałt pit in dm.Deklaracje[TypDeklaracji.PITRyczałt, okres])
					if (!wlasciciele.Contains(pit.Podmiot))
						wlasciciele.Add(pit.Podmiot);

				listPodmiot = wlasciciele.ToArray();
				this.podmiot = initialPodmiot != null && wlasciciele.Contains(initialPodmiot) ? initialPodmiot : (wlasciciele.Count == 1 ? wlasciciele[0] : null);
			}
		}


		private Params prms;

		[Context]
		public Params Prms
		{ set { prms = value; } }


		private void OnContextLoad(Object sender, EventArgs args)
		{
			List<PITRyczałt> deklaracje = new List<PITRyczałt>();
			PITRyczałt lastSeen = null;
			
			DeklaracjeModule dm = DeklaracjeModule.GetInstance(prms.Context);
			
			foreach (PITRyczałt pit in dm.Deklaracje[TypDeklaracji.PITRyczałt, prms.Okres])
			{
				if (pit.Podmiot != prms.Podmiot)
					continue;
				if (lastSeen != null && lastSeen.RokMiesiac != pit.RokMiesiac)
					deklaracje.Add(lastSeen);
				lastSeen = pit;
			}

			if (lastSeen != null)
				deklaracje.Add(lastSeen);

			GridDeklaracje.DataSource = deklaracje;

			ReportHeader["OKRES"] = prms.Okres.ToString();
			ReportHeader["PODATNIK"] = prms.Podmiot.ToString();
			ReportHeader["UDZIAL"] = deklaracje.Count > 0 ? deklaracje[0].Bloki["C"]["Udzial"].ToString() : String.Empty;
		}

		
		private void GridDeklaracje_OnBeforeRow(Object sender, RowEventArgs args)
		{
			PITRyczałt dek = (PITRyczałt)args.Row;

			cmStawka1.EditValue = dek.Bloki["C"]["Stawka1"] ;
			cmStawka2.EditValue = dek.Bloki["C"]["Stawka2"];
			cmStawka3.EditValue = dek.Bloki["C"]["Stawka3"];
			cmStawka4.EditValue = dek.Bloki["C"]["Stawka4"];
			cmStawka5.EditValue = dek.Bloki["C"]["Stawka5"];
			cmStawka6.EditValue = dek.Bloki["X"]["CStawka6"];			

			cmPrzychod1.EditValue = dek.Bloki["C"]["Podatnik1"];
			cmPrzychod2.EditValue = dek.Bloki["C"]["Podatnik2"];
			cmPrzychod3.EditValue = dek.Bloki["C"]["Podatnik3"];
			cmPrzychod4.EditValue = dek.Bloki["C"]["Podatnik4"];
			cmPrzychod5.EditValue = dek.Bloki["C"]["Podatnik5"];
			cmPrzychod6.EditValue = dek.Bloki["X"]["CPodatnik6"];			

			cmPodatek1.EditValue = dek.Bloki["E"]["Podatek1"];
			cmPodatek2.EditValue = dek.Bloki["E"]["Podatek2"];
			cmPodatek3.EditValue = dek.Bloki["E"]["Podatek3"];
			cmPodatek4.EditValue = dek.Bloki["E"]["Podatek4"];
			cmPodatek5.EditValue = dek.Bloki["E"]["Podatek5"];
			cmPodatek6.EditValue = dek.Bloki["X"]["EPodatek6"];			

			cmPodstawa1.EditValue = dek.Bloki["E"]["Przychod1"];
			cmPodstawa2.EditValue = dek.Bloki["E"]["Przychod2"];
			cmPodstawa3.EditValue = dek.Bloki["E"]["Przychod3"];
			cmPodstawa4.EditValue = dek.Bloki["E"]["Przychod4"];
			cmPodstawa5.EditValue = dek.Bloki["E"]["Przychod5"];
			cmPodstawa6.EditValue = dek.Bloki["X"]["EPrzychod6"];
        
            var odliczenia = (decimal) dek.Bloki["D"]["Razem"];	
            var razemPodatnik = (decimal) dek.Bloki["C"]["RazemPodatnik"];

		    if (razemPodatnik <= 0m)
		    {
		  	    cmOdliczenia1.EditValue = 0m;
		        cmOdliczenia2.EditValue = 0m;
		        cmOdliczenia3.EditValue = 0m;
		        cmOdliczenia4.EditValue = 0m;
		        cmOdliczenia5.EditValue = 0m;
		        cmOdliczenia6.EditValue = 0m;      
		    }
		    else
		    {
		        var wynik = KasaRozrzucKwoty.Rozrzuc(KasaRozrzucKwoty.Algorytm.ZaokraglajNajwiekszy, odliczenia , new []
		        {
		            (decimal) dek.Bloki["C"]["Podatnik1"],
                    (decimal) dek.Bloki["C"]["Podatnik2"],
                    (decimal) dek.Bloki["C"]["Podatnik3"],
                    (decimal) dek.Bloki["C"]["Podatnik4"],
                    (decimal) dek.Bloki["C"]["Podatnik5"],
                    (decimal) dek.Bloki["X"]["CPodatnik6"]
		        });

		        cmOdliczenia1.EditValue = wynik[0];
		        cmOdliczenia2.EditValue = wynik[1];
		        cmOdliczenia3.EditValue = wynik[2];
		        cmOdliczenia4.EditValue = wynik[3];
		        cmOdliczenia5.EditValue = wynik[4];
		        cmOdliczenia6.EditValue = wynik[5];
		    }

			cmPrzychod.EditValue = dek.Bloki["C"]["RazemPodatnik"];
			cmOdliczenia.EditValue = dek.Bloki["D"]["Razem"];
			cmPodstawaPodatku.EditValue = dek.Bloki["E"]["RazemPrzychod"];
			cmPodatekRazem.EditValue = dek.Bloki["E"]["RazemPodatek"];
			cmOdliczeniaPod.EditValue = dek.Bloki["F"]["Razem"];
			cmNaleznaZaliczka.EditValue = dek.Bloki["G"]["Zaliczka"];
		}
		
		
    </script>
</head>
<body>
	<form method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true"></ea:DataContext>
	<eb:ReportHeader ID="ReportHeader" runat="server" Title="Zestawienie do PIT-28|Okres: </STRONG>%OKRES%<STRONG>|Podatnik: </STRONG>%PODATNIK%<STRONG>|Udział podatnika: </STRONG>%UDZIAL%<STRONG>" ></eb:ReportHeader>
	
	<ea:Grid runat="server" ID="GridDeklaracje" RowsInRow="3" OnBeforeRow="GridDeklaracje_OnBeforeRow" >
		<Columns>
			<ea:GridColumn ID="cm1" runat="server" Caption="LP" DataMember="#" Align="Center" Total="Info"  />
			<ea:GridColumn ID="cm2" runat="server" Caption="Za miesiąc" DataMember="RokMiesiac" RowSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawaPodatku" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka1" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod1" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia1" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawa1" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek1" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka2" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod2" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia2" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawa2" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek2" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka3" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod3" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia3" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawa3" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek3" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka4" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod4" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia4" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum"  />
			<ea:GridColumn ID="cmPodstawa4" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek4" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka5" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod5" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia5" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawa5" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek5" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmStawka6" runat="server" Caption="Stawka" ColSpan="2" Align="Center"/>
			<ea:GridColumn ID="cmPrzychod6" runat="server" Caption="Przychód" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczenia6" runat="server" Caption="Odliczenia" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodstawa6" runat="server" Caption="Podstawa podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatek6" runat="server" Caption="Podatek zryczałtowany" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmPodatekRazem" runat="server" Caption="Podatek" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmOdliczeniaPod" runat="server" Caption="Odliczenia od podatku" Format="{0:N2}" Align="Right" Total="Sum" />
			<ea:GridColumn ID="cmNaleznaZaliczka" runat="server" Caption="Należna zaliczka" Format="{0:N2}" Align="Right" Total="Sum" />
		</Columns>
	</ea:Grid>
	
	<eb:ReportFooter ID="ReportFooter" runat="server">
		<Subtitles>
			<eb:FooterSubtitle runat="server" SubtitleType="Operator" />
		</Subtitles>
	</eb:ReportFooter>
	</form>
</body>
</html>

